//	DataHandler.h
//	This is the interface published by a data translator module

#pragma once

#ifndef _DATAHANDLER_H_
#define _DATAHANDLER_H_

//	file type of data handler add-ons (this, or "BAPP")
//
#define DATAHANDLER_TYPE	'DATA'

#pragma export on

//	when you export this struct, end with an empty
//	record that has 0 for "type"
//
struct Format {
	ulong		type;						//	BeOS data type
	ulong		t_cls;						//	class of this format
	float		quality;					//	format quality 0.0-1.0
	float		capability;					//	handler capability 0.0-1.0
	char		MIME[B_FILE_NAME_LENGTH];	//	MIME string
	char		formatName[B_FILE_NAME_LENGTH];	//	only descriptive
};

struct DATASpec;
struct DATAInfo;
class BView;
struct BRect;
class DStream;

extern "C" {

	extern	char			handlerName[];		//	required, C string, ex "Jon's Sound"
	extern	char			handlerInfo[];		//	required, descriptive C string, ex "Jon's Sound Handler (shareware $5: hplus@ix.netcom.com) v1.00"
	extern	long			handlerVersion;		//	required, integer, ex 100

	extern	Format			inputFormats[];		//	optional (else Identify is always called)
	extern	Format			outputFormats[];	//	optional (else Translate is called anyway)
												//	Handlers that don't export outputFormats 
												//	will not be considered by files looking for 
												//	specific output formats.

	//	Return DATA_NO_HANDLER if not handling this data.
	//	Even if inputFormats exists, may be called for data without hints
	//	Ff outType is not 0, must be able to export in wanted format

	extern	long			Identify(	//	required
								
								DStream &			inSource,
								const Format *		inFormat,
								BMessage *			ioExtension,
								DATAInfo &			outInfo,
								ulong				outType);

	//	Return DATA_NO_HANDLER if not handling the output format
	//	If outputFormats exists, will only be called for those formats

	extern	long			Translate(	//	required
								DStream &			inSource,
								const DATAInfo &	inInfo,
								BMessage *			ioExtension,
								ulong				outFormat,
								DStream &			outDestination);

	//	The view will get resized to what the parent thinks is 
	//	reasonable. However, it will still receive MouseDowns etc.
	//	A Sound handler could have a speaker icon that played the 
	//	sound when clicked, and maybe show a little waveform.
	//	The parent may, at its option, create scroll bars if the 
	//	outExtent rectangle is larger than the resized view's frame
	//	The view takes ownership of the stream, and should call 
	//	delete on it when it goes away.

	extern	long			MakeView(	//	optional
								DStream *			inSource,
								const DATAInfo &	inInfo,
								BMessage *			ioExtension,
								BView * &			outView,
								BRect &				outExtent);
}

#pragma export reset


#endif // _DATAHANDLER_H_


